/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/
/*
*******************************************************************************
* File:         errdata.c
* Description:  Error message initialized data ONLY !!!
*				******* Do NOT add code to this file ********
* Author:       SCR, BID PL24 R&D
* Created:      Jun 22, 1998
* Package:      E2926A C-API
*******************************************************************************
*/

/* ** Segmentation for DOS **
* MS allows us to put const data into its own named segment (data_seg()).
* Borland doesn't like that but does allow us to pack strings
* into the code segment (option -dc).
* Borland also ignores unknown pragmas; MS compilers give you a warning
*/

#if defined(_MSC_VER)
# pragma data_seg("errdata_c","FAR_DATA")
#elif defined(__BORLANDC__)
# pragma option -dc
#endif /* _MSC_VER etc. */


#include <typedefs.h>
#include <dyndefs.h>
#include <errcapi.h>

/*lint -e786 ... string concat within initializer */

/* the following global string array is the workaround */
/* for the missing error reporting capabilites.        */

const char perfboard_err[] = "Performance Board Error String Buffer Empty";

#define INT_PARAM	((const char **)NULL)
#define FIVE_IPS  	INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM



/* *** replacing parameter numbers with string
   You can specify up to 5 parameters to detailize an error message. In
   some cases numbers are inappropriate. Therefore you can specify a
   lookup table for each parameter for each error number and so the strings
   of the lookup table are taken instead of the numbers. The parameters serve
   then as an index into that table. */


/* *************************** important list ***************************
   List of ports
   !! Keep this list coherent with firmware define of PORTID !! */

const char *port_list[] = {
  "Unknown",
  "Debug",
  "Serial",
  "Parallel",
  "PCI",
  "LAN"
};


/* *************************** important list ***************************
   List of ports
   !! Keep this list coherent with b_porttype !! */

const char *handle_port_list[] = {
  "Serial",
  "Parallel",
  "Fast HIF",
  "PCI Config",
  "PCI I/O",
  "Offline",
  "----",
  "Not PCI",                    /* B_PORT_COUNT + 1 */
  "Only PCI"                    /* + 2 */
};


/* **********************************************************************
   List of custom parameters
   !! Keep aligned with b_paramcustom type in berror.h !! */

const char *pcst_list[] = {
  /* TODO: throw out all the generic stuff, that's not the purpose of this */
  "unknown",
  "master attribute page",
  "target attribute page",
  "trigger counter",
  "master block page",
  "offset",
  "value",
  "group",
  "config space register",
  "number of bytes",
  "data memory address",

  "trace memory number of lines",
  "trace memory number of bytes",
  "trace memory line offset",
  
  "address",
  "size",
  "device",
  
  "PPR Master Block Permutation property",
  "PPR Attribute Permutation property",
  "PPR Generic property",
  "PPR Report property"
};


/* **********************************************************************
   List of instances with relevant versions
   !! Keep aligned with b_versioncheck type in berror.h !! */

const char *verchk_list[] = {
  "firmware"
};


/* *************************** obsolete list ****************************
   List of parameter groups
   !! Keep this list coherent with list of parameter groups in berror.h !! */

const char *pgroup_list[] = {
  "unspecified",

  "exerciser",

  "master",
  "target",
  "target decoders",
  "target decoder properties",
  "configuration space",

  "analyzer",

  "CPU port",
  "CPU port properties"
};


/* *************************** important list ****************************
   List of decoders
   !! Keep this list coherent with list of decoders in tdecdefs.h !! */

const char *decoder_list[] = {
  "subtractive decode",
  "standard range 1",
  "standard range 2",
  "standard range 3",
  "standard range 4",
  "standard range 5",
  "standard range 6",
  "expansion rom",
  "configuration space",
  "customizable configuration space",
  "user configuration space"
};


/* *************************** important list ****************************
   List of PCI commands
   !! Keep this list coherent with list of decoders in masdefs.h !! */

const char *command_list [] = {
  "interrupt acknowledge",
  "special cycle",
  "IO read",
  "IO write",
  "reserved 4",
  "reserved 5",
  "memory read",
  "memory write",
  "reserved 8",
  "reserved 9",
  "config read",
  "config write",
  "memory read multiple",
  "memory read line",
  "memory write invalidate"
};


const char *generic_command_list [] = {
  "IO read",
  "IO write",
  "memory read",
  "memory write",
  "config read",
  "config write"
};


/* *************************** important list ****************************/
/* exerciser page memory list */
/* keep in order with b_pagememtype in berror.h */

const char *page_mem_list[] = {
  "Block page",
  "Master attribute page",
  "Target attribute page"
};


/* *************************** important list ****************************/
/* keep aligned with PM_ATTR... defines in setting.h */

const char *attr_progmode_list[] = {
  "!! illegal value !!",
  "BestMasterAttrLineProg or BestMasterAttrPhaseProg",
  "BestMasterAttrGroupLineProg"
};


/* *************************** important list ****************************/
/*  List of sequencer */

/* make sure this list is IDENTICAL to the b_seq_id_type enum (it is used as
   an index) in the file /cvtdevel/best2/bios/firmware/hardware/sequence.h */
const char *seq_list[] = {
  "Trigger Sequencer",
  "Trigger Out Sequencer",
  "Performance Sequencer 0",
  "Performance Sequencer 1",
  "Performance Sequencer 2",
  "Performance Sequencer 3",
  "Performance Sequencer 4",
  "Performance Sequencer 5",
  "Performance Sequencer 6",
  "Performance Sequencer 7",
  "Custom Rule Sequencer 0",
  "Custom Rule Sequencer 1",
  "Custom Rule Sequencer 2",
  "Custom Rule Sequencer 3",
  "Custom Rule Sequencer 4",
  "Custom Rule Sequencer 5",
  "Custom Rule Sequencer 6",
  "Custom Rule Sequencer 7",
  "Master Sequencer",
  "Target Sequencer",
  "Interrupt Sequencer"
};
/* ********************************************************************** */


/* *************************** important list ***************************
   List of licences
   !! Keep this list coherent with bit positions in licence field !! */

const char *licence_list[] = {
  "Unknown",                    /* bit  0, reserved */
  "Unknown",                    /* bit  1, reserved */
  "Unknown",                    /* bit  2, reserved */
  "Unknown",                    /* bit  3, reserved */
  "Unknown",                    /* bit  4, reserved */
  "Unknown",                    /* bit  5, reserved */
  "Unknown",                    /* bit  6, reserved */
  "Unknown",                    /* bit  7, reserved */
  "Trace Memory",               /* bit  8 */
  "Trace Memory",               /* bit  9 */
  "Trace Memory",               /* bit 10 */
  "Trace Memory",               /* bit 11 */
  "Performance",                /* bit 12 */
  "Performance",                /* bit 13 */
  "Performance",                /* bit 14 */
  "Unknown",                    /* bit 15 */
  "CAPI",                       /* bit 16 */
  "Analyzer",                   /* bit 17 */
  "Exerciser",                  /* bit 18 */
  "Fast Host Interface",        /* bit 19 */
  "64 Bit Facilities",          /* bit 20 */
  "66 MHz Analyzer",            /* bit 21 */
  "66 MHz Exerciser",           /* bit 22 */
  "Timing Check",               /* bit 23 */
  "System Stress Test",         /* bit 24 */
  "Protocol Permutator & Randomizer", /* bit 25 */
  "Unknown",                    /* bit 26 */
  "Unknown",                    /* bit 27 */
  "Unknown",                    /* bit 28 */
  "Unknown",                    /* bit 29 */
  "Unknown",                    /* bit 30 */
  "Unknown"                     /* bit 31, reserved */
};
/* ********************************************************************** */


/* *************************** important list ***************************
   List of IchibanModeSet errors for exerciser
   !! Keep this list coherent with defines of resources for state switching
   in .bios/best2/firmware/hardware/hwutil.c !! */

const char *ex_inimodeset_error_list[] = {
  "Unknown",                    /* 0 */
  "Master busy",                /* 1 */
  "Target Sequencer running",   /* 2 */
  "Master busy and Target Sequencer running", /* 3 */
  "Interrupt-SERR Sequencer running", /* 4 */
  "Master busy and Interrupt-SERR Sequencer running", /* 5 */
  "Target and Interrupt-SERR Sequencer running",  /* 6 */
  "Master busy, Target and Interrupt-SERR Sequencer running " /* 7 */
};
/* ********************************************************************** */

/* *************************** important list ***************************
   List of IchibanModeSet errors for analyzer
   !! Keep this list coherent with defines of resources for state switching
   in .bios/best2/firmware/hardware/hwutil.c !! */

const char *an_inimodeset_error_list[] = {
  "Unknown",                    /* 0 */
  "Performance Measurement running",  /* 1 */
  "Trace Memory running",       /* 2 */
  "Performance Measurement and Trace Memory running"  /* 3 */
};
/* ********************************************************************** */

const ErrorDescription CapiErrorStrings[] = {

  /* generic error messages */
  {NULL,
   "",B_E_OK,   /* B_E_OK, B_EFW_OK */
  FIVE_IPS},

  { "B_E_ERROR",
    "Error transferring command (%d)",
    B_E_ERROR,
    FIVE_IPS},

  /* CONSIDER: overload with windows API last error in debug mode */
  { "B_E_API_ERROR",
    "Error transferring command.",
    B_E_API_ERROR,
    FIVE_IPS},

  { "B_E_FUNC",
    "Functional onboard error",
    B_E_FUNC,  
    FIVE_IPS},


  /*************************************************************************/
  /* connecting to the card */

  { "B_E_NO_HANDLE_LEFT",
    "Cannot open another port because no handle "  
    "left. Close some ports and try again.",
    B_E_NO_HANDLE_LEFT,
    FIVE_IPS },

  { "B_E_BAD_HANDLE",
    "You have used an invalid handle or you do not have a valid" 
    " connection to a Best card.",
    B_E_BAD_HANDLE,
    FIVE_IPS },

  { "B_E_NOT_CONNECTED",
    "%s port is not connected. Please execute the "  
    "BestConnect command. This error message applies "
    "to the E2925A only.", B_E_NOT_CONNECTED,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_E_CANNOT_CONNECT",
    "%s port is unable to connect. Please check cable "  
    "and connectors and try again. If your card is a "
    "E2925A maybe it is connected exclusively.",
    B_E_CANNOT_CONNECT,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_E_CANNOT_CONNECT_EXCLUSIVE",
    "%s port cannot get an exclusive connection to " 
    "the card. Check that no other port is connected "
    "exclusively and try again. If the problem "
    "persists try a conventional connection for "
    "further help. This message applies to the E2925A "
    "only.",
    B_E_CANNOT_CONNECT_EXCLUSIVE,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_E_CANNOT_CONNECT_CORE",
    "%s port is unable to connect because the card is "  
    "operating in core mode. Please reset the card. If "
    "the problem persists run a hardware update.",
    B_E_CANNOT_CONNECT_CORE,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_E_CONNECTION_LOST",
    "%s port lost its connection. Please check cable " 
    "connection and try a close-open to re-establish "
    "the connection.",
    B_E_CONNECTION_LOST,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_E_CONNECTION_LOST_CMD",
    "%s port lost its connection. Please check cable " 
    "connection and try a close-open to re-establish "
    "the connection. (%02x:%02x)",
    B_E_CONNECTION_LOST_CMD,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_E_UNKNOWN_HARDWARE",
    "The connected hardware on the %s Port could not " 
    "be identified.",
    B_E_UNKNOWN_HARDWARE,
    handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_E_VERSION_MISMATCH",
    "Expected version %s for %s. Current version is "  
    "%s.",
    B_E_VERSION_MISMATCH,
    FIVE_IPS },

  /*************************************************************************/
  /* command and data transfer */

  /* CONSIDER: think about parameters (which command?) all functions now know
     their name */
  { "B_E_NOT_E2925A",
    "This command is not supported by the E2925A",
    B_E_NOT_E2925A, 
    FIVE_IPS},

  { "B_E_ONLY_E2925A",
    "This command is only supported by the E2925A",
    B_E_ONLY_E2925A, 
    FIVE_IPS},

  { "B_E_ONLY_E2925A_DEEP",
    "This command is only supported by the E2925A deep trace.",
    B_E_ONLY_E2925A_DEEP,
    FIVE_IPS},

  { "B_E_EPP_ONLY_E2925A",
    "Connection via LPTx port is only supported by the E2925A",
      B_E_EPP_ONLY_E2925A,
    FIVE_IPS},

  { "B_E_ONLY_COMPACT",
    "This command is only supported by the E2940A CompactPCI card",
    B_E_ONLY_COMPACT,
    FIVE_IPS},

  { "B_E_NOT_COMPACT",
    "This command is not supported by the E2940A CompactPCI card",
    B_E_NOT_COMPACT,
    FIVE_IPS},

  { "B_E_ONLY_CORE",
    "This command is supported by core software only. "  
    "Execute the BestCoreSwitch command.",
    B_E_ONLY_CORE,
    FIVE_IPS},

  { "B_E_CORE_ONLY_RS232",
    "Must use RS232 port with 9600 baud to switch to Core-firmware!",
    B_E_CORE_ONLY_RS232,
    FIVE_IPS},
  

  { "B_E_CORE_VERSION_MISMATCH",
    "Minimal Core Version for Firmware %s to be downloaded is %s; "
    "current Core Version found is %s",
    B_E_CORE_VERSION_MISMATCH,
    FIVE_IPS},

  { "B_E_WRONG_PORT",
    "This action is only applicable to the Port \"%s\". "  
    "You are connected to the Port \"%s\".",
    B_E_WRONG_PORT,
    handle_port_list, handle_port_list, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_E_UNTRANSLATED_CMD",
    "No automatic translation from 8 bit command %02x\\h to 16 bit command. "
    "Please contact support.",
    B_E_UNTRANSLATED_CMD,
    FIVE_IPS},

  /*************************************************************************/
  /* range checking and parameters */
  { "B_E_NO_CAPABILITY",
    "Your hardware is not capable of %s actions.",
    B_E_NO_CAPABILITY,
    licence_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_E_PARAM",
    "An internal parameter was out of range, unable to continue. Please "
    "check parameters of this call.",
    B_E_PARAM,
    FIVE_IPS},

  { "B_E_VALUE",
    "Parameter %s cannot take value %d in this context.",
    B_E_VALUE,
    FIVE_IPS},

  { "B_E_RANGE",
    "Parameter %s has to be in a range from %d " 
    "through %d. Its value is %d.",
    B_E_RANGE,
    FIVE_IPS},

  { "B_E_ALIGN",
    "Parameter %s must be aligned to %d. Its value is %d.",
    B_E_ALIGN,
    FIVE_IPS},

  { "B_E_PARAM_NOT_EXIST",
    "In group %d parameter %d does not exist. Either " 
    "the parameter or group index is out of range or "
    "the parameter is not licenced.",
    B_E_PARAM_NOT_EXIST,
    FIVE_IPS},

  { "B_E_SYNTAX",
    "Syntax error:",
    B_E_SYNTAX,            
    FIVE_IPS},

  { "B_E_FCT_PARAM",
    "Function %s rejected parameter '%s' : %s",
    B_E_FCT_PARAM, 
    FIVE_IPS},

  { "B_E_UNDERFLOW",
    "The value returned is less than 0. Actual value was %s",
    B_E_UNDERFLOW,
    FIVE_IPS},
  
  { "B_E_OVERFLOW",
    "The value returned is larger than 0xFFFFFFFF. Actual value was %s",
    B_E_OVERFLOW,
    FIVE_IPS},

  /*************************************************************************/
  /* master errors */

  { "B_E_MASTER_ABORT",
    "Master abort occured, no target response.",
    B_E_MASTER_ABORT,
    FIVE_IPS},

  { "B_E_SYSMEM_PREPCMD",
    "System memory access function was prepared with an illegal command."
    "Required command is '%s', chosen command is '%s'.",
    B_E_SYSMEM_PREPCMD,
    command_list, command_list, INT_PARAM, INT_PARAM, INT_PARAM },
  
  { "B_E_SYSMEM_DATACOMPARE",
    "System memory access failed because of data compare error.",
    B_E_SYSMEM_DATACOMPARE,
    FIVE_IPS },

  /*************************************************************************/
  /* decoder errors */

  { "B_E_CONFIG_VALUE_INVALID",
    "Value %08x for config space register %02x is " 
    "invalid or not PCI compliant.",
    B_E_CONFIG_VALUE_INVALID,
    FIVE_IPS},

  { "B_E_CONFIG_MASK_INVALID",
    "Mask %08x for config space register %02x is " 
    "invalid or not PCI compliant.",
    B_E_CONFIG_MASK_INVALID,
    FIVE_IPS},

  /*************************************************************************/
  /* E2925A only errors */

  { "B_E_JEDEC_UES",
    "Could not include UES in JEDEC stream",
    B_E_JEDEC_UES, 
    FIVE_IPS},

  /*************************************************************************/
  /* host errors */

  { "B_E_FILE_OPEN",
    "Could not open file '%s'.",
    B_E_FILE_OPEN, 
    FIVE_IPS},

  { "B_E_BAD_FILE_FORMAT",
    "Bad format for file '%s'.",
    B_E_BAD_FILE_FORMAT, 
    FIVE_IPS},

  { "B_E_HOST_MEM_FULL",
    "Not enough memory.",
    B_E_HOST_MEM_FULL,       
    FIVE_IPS},

  /*************************************************************************/
  /* miscellaneous errors */

  { "B_E_UNKNOWN_ERR",
    "Unknown error code %d",
    B_E_UNKNOWN_ERR,   
    FIVE_IPS},

  { "B_E_SELFTEST_FAILED",
    "The hardware selftest failed. Please contact Agilent support.",
    B_E_SELFTEST_FAILED,  
    FIVE_IPS},

  /*************************************************************************/
  /* developers section */

  { "B_E_PARTIAL_XMIT",
    "Error writing to card. Only %d of %d bytes were transmitted.",
    B_E_PARTIAL_XMIT,
    FIVE_IPS},

  { "B_E_PARTIAL_RCVE",
    "Error reading from card. Only %d of %d bytes were received.",
    B_E_PARTIAL_RCVE,
    FIVE_IPS},

  { "B_E_FILE_ITEM_NOT_FOUND",
    "Failed to find item %06x\\h in file '%s'",
    B_E_FILE_ITEM_NOT_FOUND, 
    FIVE_IPS}, 

  { "B_E_TBD",
    "To Be Done... You should never see this messages",
    B_E_TBD,  
    FIVE_IPS}, 

  { "B_E_MAXERR",
    "Last error message. You should never see this " 
    "message.",
    B_E_MAXERR,
    FIVE_IPS},

  { "B_E_INTERNAL_RETURN",
    "Internal control code. You should never see this message.",
    B_E_INTERNAL_RETURN,
    FIVE_IPS},

  /**************************************************************************/
  /* serial port */

  { "B_E_RS232_OPEN",
    "Could not open RS232 port",
    B_E_RS232_OPEN,
    FIVE_IPS},
  
  { "B_E_BAUDRATE",
    "Could not set new baud rate",  B_E_BAUDRATE,FIVE_IPS},

  /******************************************************************************/
  /* parallel port */

  { "B_E_PARALLEL_OPEN",
    "Could not open BEST EPP port driver", B_E_PARALLEL_OPEN, FIVE_IPS},

  /******************************************************************************/
  /* PCI port */

  { "B_E_PCI_OPEN",
    "Could not open BEST PCI driver", B_E_PCI_OPEN, FIVE_IPS},
  
  { "B_E_IO_OPEN",
    "Could not open BEST IO port driver", B_E_IO_OPEN, FIVE_IPS},
  
  { "B_E_NO_BEST_PCI_DEVICE_FOUND",
    "Specified device not found on PCI Bus",
    B_E_NO_BEST_PCI_DEVICE_FOUND, FIVE_IPS},
  
  { "B_E_DRIVER_VERSION_DIFF",
    "The PCI driver version is incompatible with this C-API",
    B_E_DRIVER_VERSION_DIFF, FIVE_IPS},
  
  { "B_E_PCI_NT_ONLY",
    "Win32 PCI access is only supported under Windows NT",
    B_E_PCI_NT_ONLY, FIVE_IPS},

  /******************************************************************************/
  /* fast HIF port */

  { "B_E_HIF_OPEN",
    "Could not open BEST Fast Host-Interface driver",
    B_E_HIF_OPEN, FIVE_IPS},
  
  { "B_E_HIF_WIN32_ONLY",
    "Fast Host Interface access is only supported under Win32",
    B_E_HIF_WIN32_ONLY, FIVE_IPS},

  /******************************************************************************/
  /* simulation port */

  /******************************************************************************/
  /* generic I/O ... any or all ports */

  { "B_E_GRANULARITY",
    "Requested number of bytes conflicts with specified granularity",
    B_E_GRANULARITY, FIVE_IPS},

  { "B_E_GRANULARITY_BEST",
    "Requested number of bytes conflicts with Best's granularity",
    B_E_GRANULARITY_BEST, FIVE_IPS},

  { "B_E_GRANULARITY_GT_PORT_MAX",
    "Specified granularity is larger than the port's max. I/O size",
    B_E_GRANULARITY_GT_PORT_MAX, FIVE_IPS},
  
  { "B_E_SETTING_TIMEOUTS",
    "Error setting timeouts",
    B_E_SETTING_TIMEOUTS, FIVE_IPS},

  /******************************************************************************/
  /* master related errors */
  { "B_E_MBLOCKCMD_DAC",
    "Master cannot issue the DAC command directly. Use B_BLK_BUSDAC "
    "property to enable Dual Address Cycles.",
    B_E_MBLOCKCMD_DAC, FIVE_IPS},

  /******************************************************************************/
  /* decoder related errors */
  { "B_E_NO_PCI_CLOCK",
    "No or slow PCI clock",
    B_E_NO_PCI_CLOCK, FIVE_IPS},

  { "B_E_BAD_DECODER_NUMBER",
    "No valid decoder number",
    B_E_BAD_DECODER_NUMBER, FIVE_IPS},

  { "B_E_CPU_MISALIGNED",
    "CPUPort address misaligned",
    B_E_CPU_MISALIGNED, FIVE_IPS},

  /******************************************************************************/
  /* host memory functions */
  { "B_E_WRONG_PARAMETER",
    "At least one parameter value is out of range",
    B_E_WRONG_PARAMETER, FIVE_IPS},

  { "B_E_CONF_REG",
    "Could not write to config space OR the value to write is invalid "
    "for that register",
    B_E_CONF_REG,
    FIVE_IPS},

  { "B_E_MASK_REG",
    "Could not write config mask OR the mask value is invalid for that "
    "register",
    B_E_MASK_REG,
    FIVE_IPS},
  
  { "B_E_DEC_CHECK",
    "Unknown decoder error. (May be there is no PCI clock or board HW "
    "is busy)",
    B_E_DEC_CHECK,
    FIVE_IPS},
  
  { "B_E_PROG_DEC_ENABLE",
    "BEST IO programming decoder not enabled, or could not read from "
    "config space",
    B_E_PROG_DEC_ENABLE,
    FIVE_IPS},

  { "B_E_WRONG_PROP",
    "Unknown or invalid property specified",
    B_E_WRONG_PROP, FIVE_IPS},
  
  { "B_E_TEST_NO_DECODER",
    "First Decoder not enabled",
    B_E_TEST_NO_DECODER, FIVE_IPS},

  { "B_E_INVALID_OBS_RULE",
    "Observer rule unknown or not implemented",
    B_E_INVALID_OBS_RULE, FIVE_IPS},

  { "B_E_INVALID_TC_SIG",
    "Timing Checker signal unknown or not implemented",
    B_E_INVALID_TC_SIG, FIVE_IPS},

  { "B_E_NO_DWORD_BOUNDARY",
    "Specified address must be on a DWORD boundary",
    B_E_NO_DWORD_BOUNDARY,
    FIVE_IPS},
  
  { "B_E_NO_WORD_BOUNDARY",
    "Specified address must be on a WORD boundary",
    B_E_NO_WORD_BOUNDARY ,
    FIVE_IPS},

  { "B_E_DEC_SIZE_BASE_MISMATCH",
    "There is a decoder size and base address mismatch",
    B_E_DEC_SIZE_BASE_MISMATCH,
    FIVE_IPS},
  
  { "B_E_DEC_INVALID_SIZE",
    "Invalid size specified for this decoder",
    B_E_DEC_INVALID_SIZE, 
    FIVE_IPS},
  
  { "B_E_DEC_INVALID_MODE",
    "Invalid mode specified for this decoder",
    B_E_DEC_INVALID_MODE, 
    FIVE_IPS},

  { "B_E_DEC_INVALID_DECODER",
    "This decoder is not implemented",
    B_E_DEC_INVALID_DECODER ,
    FIVE_IPS},
  { "B_E_DEC_CONFIG_ACCESS",
    "Error while accessing hardware (config space busy, or no PCI clock)",
    B_E_DEC_CONFIG_ACCESS,
    FIVE_IPS},
  
  { "B_E_HW_BUSY",
    "Board hardware is busy, or no PCI clock",
    B_E_HW_BUSY, 
    FIVE_IPS},
  
  { "B_E_DEC_BASE_WRITE",
    "Error while writing base address into HW",
    B_E_DEC_BASE_WRITE, 
    FIVE_IPS},
  
  { "B_E_DEC_BASE_NOT_0",
    "Base address must be 0 when size is 0",
    B_E_DEC_BASE_NOT_0, 
    FIVE_IPS},
  
  { "B_E_BOARD_RESET",
    "Could not re-connect after board reset",  B_E_BOARD_RESET, 
    FIVE_IPS},
  
  { "B_E_DEC_ROM_SIZE_0_ENABLED",
    "Inconsistency: Generic ROM enable active, but size is 0",
    B_E_DEC_ROM_SIZE_0_ENABLED,
    FIVE_IPS},

  /* SST errors */
  { "B_E_SST_ABORTED",
    "Test aborted.",
    B_E_SST_ABORTED,    
    FIVE_IPS},
  
  { "B_E_SST_STOPPED",
    "Test stopped by user.",
    B_E_SST_STOPPED, 
    FIVE_IPS},
  
  { "B_E_SST_SETUP_ERROR",
    "System Test can't start due to setup error.",
    B_E_SST_SETUP_ERROR,
    FIVE_IPS},
  
  { "B_E_SST_PAUSED",
    "Test paused by user.",
    B_E_SST_PAUSED,
    FIVE_IPS},
  
  { "B_E_SST_EVENTERROR",
    "Error in event callback function.",
    B_E_SST_EVENTERROR,
    FIVE_IPS},
  
  { "B_E_SST_REPORTERROR",
    "Error in report callback function.",
    B_E_SST_REPORTERROR,
    FIVE_IPS},
  
  { "B_E_SST_RESET",
    "During a test run the board has been reset.",
    B_E_SST_RESET,
    FIVE_IPS},

  { "B_E_SST_INTROPEN",
    "Could not open interrupt driver.",
    B_E_SST_INTROPEN,
    FIVE_IPS},
  
  { "B_E_SST_INTRSETUP",
    "Error while setting up interrupt test.",
    B_E_SST_INTRSETUP,
    FIVE_IPS},
  
  { "B_E_SST_INTRCONNECT",
    "Unable to connect interrupt service routine.",
    B_E_SST_INTRCONNECT,
    FIVE_IPS},
  
  { "B_E_SST_INTRERROR",
    "An IO control of the interrupt driver failed",
    B_E_SST_INTRERROR,
    FIVE_IPS},
  
  { "B_E_PPR_LIST_EMPTY",
    "Variation list empty.",
    B_E_PPR_LIST_EMPTY, 
    FIVE_IPS},
  
  { "B_E_PPR_LIST_FULL",
    "Variation list too long.",
    B_E_PPR_LIST_FULL, 
    FIVE_IPS},
  
  { "B_E_PPR_OUT_OF_RANGE",
    "Value in list <%s> out of range.",
    B_E_PPR_OUT_OF_RANGE, 
    FIVE_IPS},
  
  { "B_E_PPR_CALL_INIT",
    "PPR not initialized (call BestPprInit).",
    B_E_PPR_CALL_INIT, 
    FIVE_IPS},
  
  { "B_E_PPR_PAGESIZE_EXCEED",
    "Onboard page memory exceeded. Change max. pagesize or page number.",
    B_E_PPR_PAGESIZE_EXCEED,
    FIVE_IPS},
  
  { "B_E_PPR_FIRST_TOO_LARGE",
    "First permutation number is larger than overall permutations",
    B_E_PPR_FIRST_TOO_LARGE,
    FIVE_IPS},

  { "B_E_PPR_64BIT_RESTRICTION",
    "PPR cannot setup blocks because all possible permutations would have\n"
    "\t1. blocksize >= 20 bytes\n"
    "\t2. last address on even QWord boundary.\n"
    "This combination can cause data loss on 64bit systems.",
    B_E_PPR_64BIT_RESTRICTION,
    FIVE_IPS},

  { "B_E_WRONG_HW",
    "Operation not supported for that hardware",
    B_E_WRONG_HW, 
    FIVE_IPS},
  
  { "B_E_ROM_ENABLED",
    "Expansion ROM Decoder is enabled",
    B_E_ROM_ENABLED, 
    FIVE_IPS},
  
  { "B_E_ROM_INTERNAL",
    "Expansion ROM is used internal",
    B_E_ROM_INTERNAL, 
    FIVE_IPS},

  /* ** B_E_PERFBOARD_ERROR ** */
  { "B_E_PERFBOARD_ERROR",
    "Undocumented performance board error",
    B_E_PERFBOARD_ERROR,
    FIVE_IPS},
  /* SCR; place holder */

  { "B_E_WRONG_BUSADDR",
    "Invalid PCI bus address specified in that address space - see PCI Spec!",
    B_E_WRONG_BUSADDR,
    FIVE_IPS},

  { "B_E_REG_VALUE_NOT_DWORD",
    "The registry entry is not the correct type (Long Integer)",
    B_E_REG_VALUE_NOT_DWORD,
    FIVE_IPS},

  { "B_E_REG_VALUE_NOT_SZ",
    "The registry entry is not the correct type (String)",
    B_E_REG_VALUE_NOT_SZ,
    FIVE_IPS},

  { "B_E_REG_VALUE_NOT_GET",
    "Error retrieving the registry value",
    B_E_REG_VALUE_NOT_GET,
    FIVE_IPS},

  { "B_E_REG_VALUE_NOT_SET",
    "Error setting the registry value",
    B_E_REG_VALUE_NOT_SET, FIVE_IPS},

  { "B_E_REG_KEY_NOT_OPEN",
    "Unable to open the registry subkey (PCI driver loaded?)",
    B_E_REG_KEY_NOT_OPEN, FIVE_IPS},

  { "B_E_REG_OWNER_NONE",
    "Attempt to release a device that was not registered to any process",
    B_E_REG_OWNER_NONE, FIVE_IPS},

  { "B_E_REG_OWNER_IS_OTHER",
    "Device is registered to another process (in use)",
    B_E_REG_OWNER_IS_OTHER, FIVE_IPS},
  
  { "B_E_CONFIG_READ_BAD",
    "Invalid configuration register value detected during read",
    B_E_CONFIG_READ_BAD,
    FIVE_IPS},

  { "B_E_DYNAMIC_CAPABILITY",
    "Error while checking dynamic capabilities.",
    B_E_DYNAMIC_CAPABILITY,
    FIVE_IPS},

  { "B_E_PARAM_OUT_OF_RANGE",
    "Parameter is out of range",
    B_E_PARAM_OUT_OF_RANGE, 
    FIVE_IPS},
  
  { "B_E_PARAM_NULL_POINTER",
    "This parameter should be not a NULL-pointer",
    B_E_PARAM_NULL_POINTER ,
    FIVE_IPS},

  /* other errors */
  { "B_E_NOT_IMPLEMENTED",
    "Function not implemened",
    B_E_NOT_IMPLEMENTED,
    FIVE_IPS},

  { "B_E_COUNT",
    "Error Count (illegal code)",
    B_E_COUNT, FIVE_IPS }
};


const ErrorDescription FirmwareErrorStrings[] = {
  { "B_EFW_OK",
    (const char *) 0,
    B_EFW_OK,
    FIVE_IPS},

  /*************************************************************************/
  /* generic error messages */

  { "B_EFW_ERROR",
    "Error transfering command",
    B_EFW_ERROR,
    FIVE_IPS},

  { "B_EFW_FUNC",
    "Functional onboard error",
    B_EFW_FUNC,
    FIVE_IPS},

  /*************************************************************************/
  /* command and data transfer */

  { "B_EFW_DATA_CHECKSUM",
    "Data transmission error detected by checksum algorithm.",
    B_EFW_DATA_CHECKSUM,
    FIVE_IPS},

  { "B_EFW_CMDLOCKED",
    "Cannot execute command (%02x:%02x). Related resource is locked by "
    "port %s",
    B_EFW_CMDLOCKED,
    INT_PARAM, INT_PARAM, port_list, INT_PARAM, INT_PARAM},

  { "B_EFW_NO_CAPABILITY",
    "Cannot execute command (%02x:%02x). Hardware is not capable of "
    "%s actions.",
    B_EFW_NO_CAPABILITY,
    INT_PARAM, INT_PARAM, licence_list, INT_PARAM, INT_PARAM},

  /*************************************************************************/
  /* range checking and parameters */

  { "B_EFW_PARAM",
    "An internal parameter was out of range, unable to continue. Please "
    "check parameters of this call.",
    B_EFW_PARAM,
 	   FIVE_IPS },

  { "B_EFW_VALUE",
    "Parameter '%s' cannot take value %d in this context.",
    B_EFW_VALUE,
    FIVE_IPS },

  { "B_EFW_RANGE",
    "Parameter '%s' has to be in a range from %d through %d. Its value is %d.",
    B_EFW_RANGE,
    FIVE_IPS },
  
  { "B_EFW_ALIGN",
    "Parameter '%s' must be aligned to %d. Its value is %d.",
    B_EFW_ALIGN,
    FIVE_IPS },

  { "B_EFW_PARAM_NOT_EXIST",
    "In group %d parameter %d does not exist. Either the parameter index "
    "is out of range or the parameter is not licenced",
    B_EFW_PARAM_NOT_EXIST,
    FIVE_IPS },


  /* Timing checker range checking */
  { "B_EFW_TIMCHECK_RANGE",
    "Sum of setup and holdtime (currently %d psec) has to be at least %lu psec and at "
    "most half the clock period minus %lu psec (currently %d psec at speed %lu Hz)",
    B_EFW_TIMCHECK_RANGE,
    FIVE_IPS},

  { "B_EFW_TIMCHECK_SETUP",
    "At the current frequency of %lu Hz, setup time (was %lu psec) has to be "
    "between %lu and %lu psec (stepsize 250 psec)",
    B_EFW_TIMCHECK_SETUP,
    FIVE_IPS},

  { "B_EFW_TIMCHECK_HOLD",
    "Hold time (was %d psec) has to be between %d and %d psec (stepsize 250 psec)",
    B_EFW_TIMCHECK_HOLD,
    FIVE_IPS},

  { "B_EFW_SYNTAX",
    "Syntax error:",
    B_EFW_SYNTAX,
    FIVE_IPS }, 

  /*************************************************************************/
  /* attribute and block pages */

  { "B_EFW_PAGE_CONCATENATED",
    "%s %d is concatenated to its predecessor. Choose another page or "
    "initialize it first.",
    B_EFW_PAGE_CONCATENATED,
    page_mem_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_PAGE_EMPTY",
    "%s %d is empty, i.e. initialized but not programmed yet.",
    B_EFW_PAGE_EMPTY,
    page_mem_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_PAGE_FULL",
    "%s %d is full, i.e. end of memory reached.",
    B_EFW_PAGE_FULL,
    page_mem_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_ILLEGAL_PAGE_OFFSET",
    "%s %d has only %d lines to address. Requested offset is %d",
    B_EFW_ILLEGAL_PAGE_OFFSET,
    page_mem_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_ATTR_PROGMODE_MIXED",
    "%s %d has to be programmed with %s",
    B_EFW_ATTR_PROGMODE_MIXED,
    page_mem_list, INT_PARAM, attr_progmode_list, INT_PARAM, INT_PARAM},

  { "B_EFW_BADIAD_MISMATCH",
    "Address bit 2 of bus address and data memory address (internal "
    "address or compare offset, depending on B_BLK_COMPFLAG) have to "
    "be equal. Bus address is 0x%x, data memory address is 0x%x",
    B_EFW_BADIAD_MISMATCH,
    FIVE_IPS},

  /*************************************************************************/
  /* master errors */

  { "B_EFW_MEN_NOT_SET",
    "Master cannot run, because master not enabled in config space.",
    B_EFW_MEN_NOT_SET,
    FIVE_IPS},

  { "B_EFW_MBLOCKCMD_DAC",
    "Master cannot issue the DAC command directly. Use B_BLK_BUSDAC "
    "property to enable Dual Address Cycles.",
    B_EFW_MBLOCKCMD_DAC,
    FIVE_IPS},

  { "B_EFW_MASTER_WARN64BIT",
    "Master will not run because a req64 was issued in combination with "
    "an odd/even blocksize/busaddr combination. Use variable bytenables "
    "to make sure no superfluous data is transfered and reset master generic "
    "property B_MGEN_WARN64BIT.",
    B_EFW_MASTER_WARN64BIT,
    FIVE_IPS},
  
  { "B_EFW_64BIT_RESTRICTION",
    "Master will not run because a req64 was issued in combination with "
    "\t1. blocksize >= 20 bytes\n"
    "\t2. last address is on even QWord boundary."
    "This combination can cause data loss on 64bit systems.",
    B_EFW_MASTER_64BIT_RESTRICTION,
    FIVE_IPS},
  
  /*************************************************************************/
  /* decoder errors */

  { "B_EFW_DECODER_NO_DAC",
    "Decoder '%s' cannot decode DACs. Only odd numbered decoders have "
    "this capability",
    B_EFW_DECODER_NO_DAC,
    decoder_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_DECODER_GRABBED",
    "Decoder '%s' is unaccessible, because its base register serves "
    "as upper half of a 64-bit decoder",
    B_EFW_DECODER_GRABBED,
    decoder_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_FASTDECODER_GRABBED",
    "Decoder '%s' cannot be set to fast decoding speed because decoder "
    "'%s' is still set to fast speed",
    B_EFW_FASTDECODER_GRABBED,
    decoder_list, decoder_list, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_BASEDEC_NOT_NORMAL",
    "Decoder '%s' cannot serve as a base decoder for decoder '%s' "
    "because it is not switched to normal behavior.",
    B_EFW_BASEDEC_NOT_NORMAL,
    decoder_list, decoder_list, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_OVERLAY_RANGE_SUBSET",
    "The base decoder's '%s' decode range has to be a superset of "
    "overlaid decoder's '%s' range.",
    B_EFW_OVERLAY_RANGE_SUBSET,
    decoder_list, decoder_list, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_OVERLAY_CMD_SUBSET",
    "The base decoder's '%s' decode commands has to be a superset of "
    "overlaid decoder's '%s' range.",
    B_EFW_OVERLAY_CMD_SUBSET,
    decoder_list, decoder_list, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_CONFIG_CMD_SUBSET",
    "Decoder '%s' accepts only config commands in the command parameter. "
    "The current command mask is %04X.",
    B_EFW_CONFIG_CMD_SUBSET,
    decoder_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  { "B_EFW_FASTDECODER_COMMAND_ERROR",
    "Decoder '%s' cannot be set to fast decoding speed because the "
    "command pattern '%d' is not supported for this speed. Please refer "
    "to the documentation for supported command sets.",
    B_EFW_FASTDECODER_COMMAND_ERROR,
    decoder_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  /*************************************************************************/
  /* pattern parser errors */

  { "B_EFW_PATT_SYNTAX",
    "Syntax error in %d:",
    B_EFW_PATT_SYNTAX,
    FIVE_IPS},

  { "B_EFW_PATT_UNDEF_TOKEN",
    "Undefined token in %d:",
    B_EFW_PATT_UNDEF_TOKEN,
    FIVE_IPS},

  { "B_EFW_PATT_MTO_LISTSIGNAL",
    "OR operation on different list types in %d.",
    B_EFW_PATT_MTO_LISTSIGNAL,
    FIVE_IPS},

  { "B_EFW_PATT_UNKNOWN_ERR",
    "Error parsing %d.",
    B_EFW_PATT_UNKNOWN_ERR,
    FIVE_IPS},

  /*************************************************************************/
  /* Deep Trace Memory errors */
  { "B_EFW_DEEPTRACE_FUNC",		/* Deep Trace FIFO not empty */
    "Deep Trace board may be defect!",
    B_EFW_DEEPTRACE_FUNC,
    FIVE_IPS},

  /*************************************************************************/
  /* environment errors */

  { "B_EFW_CALIBRATION",
    "Timing checker needs calibration from Agilent for proper function",
    B_EFW_CALIBRATION,
    FIVE_IPS },

  { "B_EFW_PCICLK_TOO_SLOW",
    "PCI clock too slow or not running",
    B_EFW_PCICLK_TOO_SLOW,
    FIVE_IPS },

  { "B_EFW_PCICLK_TOO_FAST",
    "PCI clock too fast",
    B_EFW_PCICLK_TOO_FAST,
    FIVE_IPS },

  { "B_EFW_PCI_NOPOWER",
    "PCI bus is not powered",
    B_EFW_PCI_NOPOWER,
    FIVE_IPS },

  { "B_EFW_EX_INIMODESET_FAILED",
    "Programming of exerciser failed, because %s",
    B_EFW_EX_INIMODESET_FAILED,
    ex_inimodeset_error_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM },

  { "B_EFW_AN_INIMODESET_FAILED",
    "Programming of analyzer failed, because %s",
    B_EFW_AN_INIMODESET_FAILED,
    an_inimodeset_error_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM },

  { "B_EFW_TARGET_BUSY",
    "Programming of exerciser failed because target is still active. "
    "Maybe the PCI clock is too slow or target is hung.",
    B_EFW_TARGET_BUSY,
    FIVE_IPS },

  { "B_EFW_TARGET_DISABLED",
    "Programming of decoders is not allowed when target jumper is removed. "
    "Please refer to documentation for jumper settings.",
    B_EFW_TARGET_DISABLED,
    FIVE_IPS },

  /*************************************************************************/
  /* miscellaneous errors */

  { "B_EFW_ICHIBANTEST_FAILED",
    "The selftest of memory %d failed. %d errors were found. "
    "Address of first error is %06x. Written data at this address "
    "was %08x, data read is %08x.",
    B_EFW_ICHIBANTEST_FAILED,
    FIVE_IPS},

  { "B_EFW_IMAGE_TOO_LARGE",
    "The image is too large to be programmed into ROM. Either the "
    "selected sector is to small or RAM is to small to shadow the image.",
    B_EFW_IMAGE_TOO_LARGE,
    FIVE_IPS},

  { "B_EFW_LIFELOCK_PREVENTION",
    "The last command failed to prevent the system from a lifelock "
    "situation. One possible reason is a data memory up/download when "
    "the card is connected by PCI at the same time. Please refer to the "
    "manual for more information.",
    B_EFW_LIFELOCK_PREVENTION,
    FIVE_IPS},

  { "B_EFW_CARD_MEM_FULL",
    "Not enough onboard memory.",
    B_EFW_CARD_MEM_FULL,
    FIVE_IPS},

  /*************************************************************************/
  /* developers' errors */

  { "B_EFW_TBD",
    "To Be Done... You should never see this messages",
    B_EFW_TBD,
    FIVE_IPS},

  { "B_EFW_MAXERR",
    "Last error message. You should never see this message.",
    B_EFW_MAXERR,
    FIVE_IPS},

  { "B_EFW_UNKNOWNCMD",
    "Unknown command: %02x %02x\\h",
    B_EFW_UNKNOWNCMD,
    FIVE_IPS},


  /*************************************************************************/
  /* ***** end of group ***** */

  { "B_EFW_INVALID_KEY",
    "Invalid key",
    B_EFW_INVALID_KEY,
    FIVE_IPS},

  /* ***** end of group ***** */

  /* #1 - parameter group #2 - index within group #3 - value of parameter */
  { "B_EFW_OUTOFRANGE",
    "In group '%s' parameter #%d was out of range (%d)",
    B_EFW_OUTOFRANGE,
    pgroup_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  /* ***** beginning out group ***** */
  /* #1 - group byte #2 - member byte #3 - locking port (not for all in
   * group) or missing licence */

  { "B_EFW_WRONGPORT",
    "Command %02x %02x\\h has to be issued from port %s.",
    B_EFW_WRONGPORT,
    INT_PARAM, INT_PARAM, port_list, INT_PARAM, INT_PARAM},

  /* ***** end of group ***** */


  /* ROM management */

  { "B_EFW_DBRESETTED",
    "Serious error: Database was reset to all zero. "
    "Memory leaks were inevitable.",
    B_EFW_DBRESETTED, FIVE_IPS},

  /* #1 - address #2 - value */
  { "B_EFW_EXPROM_FAILED",
    "Access to expansion ROM failed (address=0x%x, value=0x%x)",
    B_EFW_EXPROM_FAILED, FIVE_IPS},

  /* sequencer errors following here */

  { "B_EFW_SEQ_SYNTAX_ERR",
    "%s: Syntax Error in Line: %d.",
    B_EFW_SEQ_SYNTAX_ERR,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},
  
  { "B_EFW_SEQ_TOO_MANY_STATES",
    "%s: Line %d: Too many states (max is %d).",
    B_EFW_SEQ_TOO_MANY_STATES,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},
  
  { "B_EFW_SEQ_TOO_MANY_INPUTS",
    "%s: Line %d: Too many Inputs (max is %d with %d states).",
    B_EFW_SEQ_TOO_MANY_INPUTS,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},
  
  { "B_EFW_SEQ_UNKNOWN_TOKEN",
    "%s: Unknown token in Line: %d",
    B_EFW_SEQ_UNKNOWN_TOKEN,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},
  
  { "B_EFW_SEQ_UNKNOWN_OUTPUT",
    "%s: Unknown output in Line: %d",
    B_EFW_SEQ_UNKNOWN_OUTPUT ,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},
  
  { "B_EFW_SEQ_TRAN_EXCLUSIVE",
    "%s: Transitions leaving state %d not exclusive.",
    B_EFW_SEQ_TRAN_EXCLUSIVE,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},
  
  { "B_EFW_SEQ_BUNDLE_SIGNAL",
    "%s: Cannot output this value (too big) in Line: %d",
    B_EFW_SEQ_BUNDLE_SIGNAL,
    seq_list, INT_PARAM, INT_PARAM, INT_PARAM, INT_PARAM},

  /* UNIX debug session */
  { "B_EFW_EOF",
    "Unexpected end of file (UNIX)",
    B_EFW_EOF,
    FIVE_IPS},

  { "B_EFW_FWRITE",
    "Error in file write operation (UNIX)",
    B_EFW_FWRITE,
    FIVE_IPS},

  { "B_EFW_FREAD",
    "Error in file read operation (UNIX)",
    B_EFW_FREAD,
    FIVE_IPS},

  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  /* -------- BLOCK AND ATTRIBUTE MEMORY ------------------------------ */
  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */

  { "B_EFW_NO_EOP_FOUND",
    "Could not find an EndOfPage(EOP) block in page %lu",
    B_EFW_NO_EOP_FOUND,
    FIVE_IPS},
  
  { "B_EFW_INVALID_ATTRPOINTER",
    "Block %lu of page %lu contains pointer to attributepage %lu,"
    "which is either empty, non-existent or concatenated",
    B_EFW_INVALID_ATTRPOINTER,
    FIVE_IPS},

  /* BestMasterBlockRun() */
  { "B_EFW_INVALID_PREP_ATTRPOINTER",
    "Preparation register contains pointer to attributepage %lu,"
    "which is either empty, non-existent or concatenated",
    B_EFW_INVALID_PREP_ATTRPOINTER,
    FIVE_IPS},

  { "B_EFW_LONG_OPERATION",
    "Hardware is in a long operation",
    B_EFW_LONG_OPERATION,
    FIVE_IPS},

  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  /* --------some internal error messages - always at the end---------- */
  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  { "B_EFW_INTERNAL_RETURN",
    "Internal Return",
    B_EFW_INTERNAL_RETURN,
    FIVE_IPS},
  
  { "B_EFW_CMDFOUND",
    "Command Found",
    B_EFW_CMDFOUND,
    FIVE_IPS},

  { "B_EFW_COUNT",
    "Error Count (illegal code)",
    B_EFW_COUNT, FIVE_IPS }
};


